/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.AutoWorkbenchRenderer;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ModWorkbenchRenderer
extends IEBlockEntityRenderer<ModWorkbenchBlockEntity> {
    public void render(ModWorkbenchBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.isDummy() || !te.getLevelNonnull().m_46805_(te.m_58899_())) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        Direction facing = te.getFacing();
        float angle = facing == Direction.NORTH ? 0.0f : (facing == Direction.WEST ? 90.0f : (facing == Direction.EAST ? -90.0f : 180.0f));
        matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), angle, true));
        ItemStack stack = (ItemStack)te.getInventory().get(0);
        boolean showIngredients = true;
        if (!stack.m_41619_()) {
            if (stack.m_41720_() instanceof EngineersBlueprintItem) {
                matrixStack.m_85836_();
                double playerDistanceSq = ClientUtils.mc().f_91074_.m_20238_(Vec3.m_82512_((Vec3i)te.m_58899_()));
                if (playerDistanceSq < 120.0) {
                    BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(te.m_58904_(), ItemNBTHelper.getString(stack, "blueprint"));
                    int l = recipes.length;
                    int perRow = l > 6 ? l - 3 : (l > 4 ? l - 2 : (l == 1 ? 2 : (l == 2 ? 3 : l)));
                    matrixStack.m_85837_(0.0, 0.501, 0.0);
                    matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
                    matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -22.5f, true));
                    matrixStack.m_85837_(0.39, l > 4 ? 0.72 : 0.78, 0.0);
                    float scale = l > 4 ? 0.009375f : 0.012f;
                    matrixStack.m_85841_(scale, -scale, scale);
                    int rendered = 0;
                    for (int i = 0; i < l; ++i) {
                        AutoWorkbenchRenderer.BlueprintLines blueprint;
                        BlueprintCraftingRecipe recipe = recipes[i % recipes.length];
                        AutoWorkbenchRenderer.BlueprintLines blueprintLines = blueprint = recipe == null ? null : AutoWorkbenchRenderer.getBlueprintDrawable(recipe, te.getLevelNonnull());
                        if (blueprint == null) continue;
                        double dX = rendered < perRow ? 0.93725 / (double)scale - (double)perRow * 16.6 + (double)rendered * 16.6 : 0.70375 / (double)scale - (double)(rendered % perRow) * 16.6;
                        double dY = rendered < perRow ? 0.0 : -0.15625;
                        matrixStack.m_85837_(dX, dY / (double)scale, 0.0);
                        float texScale = (float)blueprint.textureScale / 16.0f;
                        matrixStack.m_85841_(1.0f / texScale, 1.0f / texScale, 1.0f / texScale);
                        blueprint.draw(matrixStack, bufferIn, combinedLightIn);
                        matrixStack.m_85841_(texScale, texScale, texScale);
                        matrixStack.m_85837_(-dX, -dY / (double)scale, 0.0);
                        ++rendered;
                    }
                }
                matrixStack.m_85849_();
            } else {
                showIngredients = false;
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.0, 0.5625, 0.0);
                matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f, true));
                matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true));
                matrixStack.m_85837_(-0.875, 0.0, 0.0);
                matrixStack.m_85841_(0.75f, 0.75f, 0.75f);
                try {
                    ClientUtils.mc().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                matrixStack.m_85849_();
            }
        }
        if (showIngredients) {
            for (int i = 1; i < te.getInventory().size(); ++i) {
                double dZ;
                double dX;
                if (i < 5) {
                    dX = -0.5 + (i == 2 ? -0.0625 : (i == 4 ? 0.03215 : 0.0));
                    dZ = (double)i * 0.25 - 0.625;
                } else {
                    dX = -1.25;
                    dZ = -0.125 + (double)(i - 5) * -0.25;
                }
                stack = (ItemStack)te.getInventory().get(i);
                if (stack.m_41619_()) continue;
                matrixStack.m_85836_();
                matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f, true));
                matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true));
                matrixStack.m_85837_(dX, dZ, -0.515);
                matrixStack.m_85841_(0.25f, 0.25f, 0.25f);
                try {
                    ClientUtils.mc().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
    }
}

